/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.plan;

import com.google.common.base.Preconditions;
import cz.insophy.inplan.plan.ActionActivity;
import cz.insophy.inplan.plan.CumulativeWorkplaceActivity;
import cz.insophy.inplan.plan.Plan;
import cz.insophy.inplan.plan.WorkplaceActivity;
import cz.insophy.inplan.plan.WorkplaceSchedule;
import cz.insophy.inplan.shop.CumulativeAction;
import cz.insophy.inplan.shop.Workplace;

public class CumulativeWorkplaceSchedule
extends WorkplaceSchedule {
    private final Plan plan;

    public CumulativeWorkplaceSchedule(Plan plan, Workplace workplace) {
        super(workplace);
        if (!workplace.isCumulative()) {
            throw new IllegalArgumentException("CumulativeWorkplaceSchedule must be created on the cumulative workplace.");
        }
        this.plan = plan;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void addActivity(WorkplaceActivity activity) {
        if (activity instanceof ActionActivity) {
            WorkplaceActivity wa = super.getActivityStartIncl(activity.getStart());
            ActionActivity aa = (ActionActivity)activity;
            if (wa == null) {
                Preconditions.checkState(aa.getAction() instanceof CumulativeAction, "Cannot put cumulative action %s on a non-cumulative workplace %s", (Object)aa.getAction(), (Object)this.getWorkplace());
                CumulativeWorkplaceActivity cwa = new CumulativeWorkplaceActivity(activity.getStart(), activity.getEnd(), aa.getAction().getRebuildType(), ((CumulativeAction)aa.getAction()).getCumulationType(), activity.getWorkplace());
                this.plan.addActivity(cwa);
                cwa.addActionActivity(aa);
                return;
            } else {
                if (!(wa instanceof CumulativeWorkplaceActivity)) throw new IllegalStateException("cannot add ActionActivity into other type than CWA");
                ((CumulativeWorkplaceActivity)wa).addActionActivity(aa);
            }
            return;
        } else {
            super.addActivity(activity);
        }
    }

    @Override
    public void removeActivity(WorkplaceActivity activity) {
        if (activity instanceof ActionActivity) {
            WorkplaceActivity wa = super.getActivityStartIncl(activity.getStart());
            if (wa == null) {
                throw new IllegalStateException(activity + " is not part of any wrapper ");
            }
            ((CumulativeWorkplaceActivity)wa).removeActionActivity((ActionActivity)activity);
            if (((CumulativeWorkplaceActivity)wa).getActionActivities().size() == 0) {
                this.plan.removeActivity(wa);
            }
        } else {
            super.removeActivity(activity);
        }
    }
}

